@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('menu::backend.index') }}
        @slot('actions')
            @backButton(['name' => trans('dashboard::backend.index')])
            @createButton(['name' => trans('menu::backend.create'), 'url' => route('backend.menu.create')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.menu.datatable') }}"
            resource-url="{{ route('backend.menu.index') }}"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                            :value="getFilterValue('status')"
                            @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="Active">Active</option>
                        <option value="Inactive">Inactive</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>
        </data-table>
    @endcomponent
@stop
