@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $menu->name }}
        @slot('actions')
            @deleteButton(['name' => trans('menu::backend.delete'), 'url' => route('backend.menu.destroy', $menu->id)])
            @backButton(['name' => trans('menu::backend.index'), 'url' => route('backend.menu.index')])
            @editButton(['name' => trans('menu::backend.edit'), 'url' => route('backend.menu.edit', $menu->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Name', 'value' => $menu->name])
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Status', 'value' => $menu->status])
                @endcomponent
            </div>
        </section>

        <section>
            @if ($menu->hasItems())
                @foreach($menu->items as $menuItem)
                    @include('menu::backend.partials.menu_item', [
                        'menuItem' => $menuItem,
                        'index' => $loop->index,
                        'depth' => 1,
                    ])

                    @if($menuItem->hasNestedChildren())
                        <div class="sub-menu">
                            @foreach($menuItem->nestedChildren as $childItem)
                                @include('menu::backend.partials.sub_menu_item', [
                                    'subMenuItem' => $childItem,
                                    'index' => $loop->index,
                                    'depth' => 2,
                                ])
                            @endforeach
                        </div>
                    @endif
                @endforeach
            @else
                @component('blade::card')
                    <div class="message text-center">
                        <div class="message-text font-semibold">
                            No Menu Items Found
                        </div>
                    </div>
                @endcomponent
            @endif
        </section>
    @endcomponent
@stop
