@php
    $groupBy = 5;
@endphp

@if (isset($menu) && $menu->hasItems())
    <div class="row">

        @foreach($menu->items->chunk($groupBy) as $chunk)
            <div class="col-{{ $menu->items->count() > $groupBy ? 6 : 12 }}">
                <ul class="list list-icons list-icons-sm {{ $ulClass ?? '' }}">
                    @foreach($chunk as $menuItem)
                        <li>
                            @if(isset($showBullets))
                                <i class="fas fa-angle-right"></i>
                            @endif
                            <a href="{{ $menuItem->getLink() }}"
                               title="Link to {{ $menuItem->name }}"
                               aria-label="Link to {{ $menuItem->name }}"
                               target="{{ $menuItem->target }}"
                            >
                                {{ $menuItem->name }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endforeach

    </div>
@endif
