<li
    @class([
        'nav-item',
        'nav-item-'.$index +1 => true,
        'nav-item-'.Str::slug($menuItem->name) => true,
        'active' => $menuItem->isActive(),
        'dropdown has-children' => $menuItem->hasChildren(),
        $menuItem->class => ! empty($menuItem->class),
    ])
    data-depth="{{ $depth }}"
    data-index="{{ $index }}"
>
    @if(! $menuItem->hasChildren())
        <a class="nav-link"
           href="{{ $menuItem->getLink() }}"
           title="Link to {{ $menuItem->name }}"
           aria-label="Link to {{ $menuItem->name }}"
           target="{{ $menuItem->target }}"
        >
            {{ $menuItem->name }}
        </a>
    @else
        <a class="nav-link dropdown-toggle"
           href="javascript:void(0)"
           role="button"
           data-bs-toggle="dropdown"
           data-bs-auto-close="outside"
           aria-haspopup="true"
           aria-expanded="false"
        >
            {{ $menuItem->name }}
        </a>

        <ul class="dropdown-menu">
            @foreach($menuItem->children as $childItem)
                @include('menu::frontend.partials.main_menu_dropdown_item', [
                    'dropdownItem' => $childItem,
                    'index' => $loop->index,
                    'depth' => 2,
                ])
            @endforeach
        </ul>

    @endif
</li>
