@if (isset($menu) && $menu->hasItems())
    <ul class="sub-menu {{ ! empty($menu->name) ? Str::slug($menu->name) : '' }} nav">
        @foreach($menu->items as $menuItem)

            @if($menuItem->hasChildren())
                <li class="nav-item dropdown nav-item-{{ Str::slug($menuItem->name) }}">
                    <a class="nav-link dropdown-toggle"
                       href="javascript:void(0)"
                       role="button"
                       data-bs-toggle="dropdown"
                       aria-haspopup="true"
                       aria-expanded="false"
                    >
                        {{ $menuItem->name }}
                    </a>

                    <div class="dropdown-menu">
                        @foreach($menuItem->children as $childItem)
                            <a class="dropdown-item"
                               href="{{ $childItem->getLink() }}"
                               title="Link to {{ $childItem->name }}"
                               aria-label="Link to {{ $childItem->name }}"
                               target="{{ $childItem->target }}"
                            >
                                {{ $childItem->name }}
                            </a>
                        @endforeach
                    </div>
                </li>
            @else
                <li class="nav-item nav-item-{{ Str::slug($menuItem->name) }} {{ $menuItem->isActive() ? 'active' : '' }}">
                    <a class="nav-link"
                       href="{{ $menuItem->getLink() }}"
                       title="Link to {{ $menuItem->name }}"
                       aria-label="Link to {{ $menuItem->name }}"
                       target="{{ $menuItem->target }}"
                    >
                        {{ $menuItem->name }}
                    </a>
                </li>
            @endif

        @endforeach
    </ul>
@endif
