# Changelog

All notable changes to `bongo/openai` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.1] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (419 lines) - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` (417 lines) - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` (916 lines) - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` (455 lines) - GitHub Copilot code templates and patterns
- **Enhanced README.md**: Expanded with comprehensive installation, usage, and integration sections (343 new lines)

## [3.0.0] - 2025-07-07

### Major Release - Initial v3.0 Release

This is the initial release of the bongo/openai package, providing OpenAI integration for AI-powered content generation.

### Added

#### Service Provider
- **OpenAIServiceProvider**: Extended from `AbstractServiceProvider`
  - Automatic configuration loading from `src/Config/openai.php`
  - API key auto-configuration from settings
  - Boot method automatically sets OpenAI API key from settings if not in environment
  - Integration with Bongo framework package system

#### AI Services

##### AbstractAI Base Class
- **Abstract Base Service**: `src/Services/AbstractAI.php` (66 lines)
  - Fluent builder pattern for AI parameters
  - Properties: `model`, `temperature`, `maxTokens`, `topP`, `frequencyPenalty`, `presencePenalty`
  - Fluent setters with config fallbacks
  - Abstract `generate()` method for subclass implementation
  - Shared functionality for all AI service types

##### ContentAI Service
- **Chat-Based Content Generation**: `src/Services/ContentAI.php` (82 lines)
  - Extends `AbstractAI`
  - Properties: `instruction` (system role), `prompt` (user message)
  - Methods: `setInstruction()`, `setPrompt()`, `generate()`
  - Uses OpenAI Chat API (`OpenAI::chat()->create()`)
  - Returns formatted content with `nl2br()` applied
  - Null return on API errors (no exceptions)
  - Request validation before API calls

#### Configuration System
- **Comprehensive Config**: `src/Config/openai.php` (13 new lines)
  - API key configuration (`OPENAI_API_KEY`)
  - Organization ID (`OPENAI_ORGANIZATION`)
  - Project ID (`OPENAI_PROJECT`)
  - Base URI (`OPENAI_BASE_URL`)
  - Request timeout (`OPENAI_REQUEST_TIMEOUT`, default: 30s)
  - Default model (`OPENAI_MODEL`, default: 'gpt-4.1-mini')
  - Max tokens (`OPENAI_MAX_TOKENS`, default: 500)
  - Temperature (`OPENAI_TEMPERATURE`, default: 1)
  - Top P (`OPENAI_TOP_P`, default: 1)
  - Frequency penalty (`OPENAI_FREQUENCY_PENALTY`, default: 0)
  - Presence penalty (`OPENAI_PRESENCE_PENALTY`, default: 0)
  - All parameters support environment variable overrides

#### Package Registration
- **Package Seeder**: `src/Seeders/PackageSeeder.php`
  - Registers package in Bongo package system
  - Package name: 'OpenAI'
  - Package key: 'openai'
  - Status: `Package::ACTIVE`
  - Visibility: `Package::HIDDEN` (not shown in admin UI)

#### Development Infrastructure
- **Package Structure**: Initial package setup
  - `.editorconfig` - Consistent code formatting
  - `.gitignore` - Git ignore rules
  - `.php_cs` - PHP CS Fixer configuration
  - `.styleci.yml` - StyleCI configuration (Laravel preset)
  - `LICENSE` - MIT license
  - `README.md` - Package documentation
  - `auth.json` - Composer authentication
  - `composer.json` - Package dependencies
  - `phpstan-baseline.neon` - PHPStan baseline
  - `phpstan.neon.dist` - PHPStan configuration (level 1)
  - `phpunit.xml.dist` - PHPUnit configuration
  - `pint.json` - Laravel Pint configuration

#### Dependencies
- **OpenAI PHP SDK**: `openai-php/laravel` ^0.11.0 - Official OpenAI PHP SDK
- **Framework Integration**: `bongo/framework` ^3.0 - Base abstractions
- **Laravel Support**: `illuminate/contracts` ^10.0||^11.0

### Features

#### Fluent Builder Pattern
```php
$content = (new ContentAI)
    ->setInstruction('Rewrite to be standard English')
    ->setPrompt('Your content here')
    ->setModel('gpt-4.1-mini')
    ->setTemperature(0.7)
    ->setMaxTokens(200)
    ->generate();
```

#### Configuration Fallbacks
- All setter methods use config values as fallbacks
- Environment variables override default config
- Settings system override for API key

#### Response Handling
- Validates response structure before extraction
- Returns `null` on invalid responses (no exceptions)
- Applies `nl2br()` to content responses automatically

#### Request Validation
- Validates instruction and prompt are not empty
- Throws `InvalidArgumentException` on validation failure
- Prevents unnecessary API calls

### Statistics
- 5 files changed with 2,550 insertions and 12 deletions
- 2 core service classes (AbstractAI, ContentAI)
- 1 service provider with API key auto-configuration
- Comprehensive configuration system with 11 parameters
- Service-only package (no routes, controllers, or middleware)

### Notes
- Package is in early development (initial v3.0 release)
- Hidden from admin UI (service-only package)
- Extensible architecture for additional AI service types
- Integration with Bongo settings system for API key management

---

**Package**: `bongo/openai`
**Description**: OpenAI integration for AI-powered content generation
**Repository**: https://bitbucket.org/designtec/openai
**Private Composer Repository**: https://designtecpackages.co.uk
