<?php

declare(strict_types=1);

namespace Bongo\OpenAI;

use Bongo\Framework\Providers\AbstractServiceProvider;

class OpenAIServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'openai';

    public function boot(): void
    {
        parent::boot();

        // Once the app is booted override the open api keys
        $this->app->booted(function () {
            $config = $this->app->make('config');
            if (empty($config->get('openai.api_key')) && ! empty(setting()->getOpenAIApiKey())) {
                $config->set('openai.api_key', setting()->getOpenAIApiKey());
            }
        });
    }
}
