<?php

declare(strict_types=1);

namespace Bongo\OpenAI\Seeders;

use Bongo\Package\Models\Package;
use Bongo\Package\Traits\SeedsPackage;
use Illuminate\Database\Seeder;

class PackageSeeder extends Seeder
{
    use SeedsPackage;

    public function run(): void
    {
        $this->package([
            'name' => 'OpenAI',
            'key' => 'openai',
            'route' => 'backend.page',
            'icon' => 'openai',
            'status' => Package::ACTIVE,
            'is_visible' => Package::HIDDEN,
        ]);
    }
}
