<?php

declare(strict_types=1);

namespace Bongo\OpenAI\Services;

use OpenAI\Laravel\Facades\OpenAI;

abstract class AbstractAI
{
    protected string $model;

    protected int $temperature;

    protected int $maxTokens;

    protected int $topP;

    protected int $frequencyPenalty;

    protected int $presencePenalty;

    abstract public function generate(): ?string;

    public function setModel(?string $model = null): self
    {
        $this->model = $model ?? config('openai.model', 'gpt-4.1-mini');

        return $this;
    }

    public function setTemperature(?int $temperature = null): self
    {
        $this->temperature = $temperature ?? config('openai.temperature', 1);

        return $this;
    }

    public function setMaxTokens(?int $maxTokens = null): self
    {
        $this->maxTokens = $maxTokens ?? config('openai.max_tokens', 500);

        return $this;
    }

    public function setTopP(?int $topP = null): self
    {
        $this->topP = $topP ?? config('openai.top_p', 1);

        return $this;
    }

    public function setFrequencyPenalty(?int $frequencyPenalty = null): self
    {
        $this->frequencyPenalty = $frequencyPenalty ?? config('openai.frequency_penalty', 0);

        return $this;
    }

    public function setPresencePenalty(?int $presencePenalty = null): self
    {
        $this->presencePenalty = $presencePenalty ?? config('openai.presence_penalty', 0);

        return $this;
    }
}
