<?php

use Bongo\Package\Models\Package;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackagesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('packages')) {
            Schema::create('packages', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                $table->string('name');
                $table->string('key')->nullable()->index();
                $table->string('route')->nullable();
                $table->string('icon')->nullable();

                $table->enum('status',
                    [Package::PENDING, Package::ACTIVE, Package::INACTIVE])->default(Package::PENDING);
                $table->enum('type',
                    [Package::STANDARD, Package::EXTENDED, Package::CUSTOM])->default(Package::STANDARD);
                $table->unsignedTinyInteger('is_visible')->default(Package::VISIBLE);

                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('packages');
    }
}
