<?php

namespace Bongo\Package\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Bongo\Framework\Traits\HasVisible;
use Bongo\Package\Traits\HasType;
use InvalidArgumentException;

class Package extends AbstractModel
{
    public const VENDOR_NAME = 'bongo';
    public const VENDOR_FOLDER = 'vendor';
    public const PENDING = 'pending';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';
    public const VISIBLE = 1;
    public const HIDDEN = 0;
    public const STANDARD = 'standard';
    public const EXTENDED = 'extended';
    public const CUSTOM = 'custom';

    use HasKey;
    use HasStatus;
    use HasType;
    use HasUUID;
    use HasVisible;

    /** @var array */
    protected $fillable = [
        'name',
        'route',
        'icon',
        'status',
        'type',
        'is_visible',
    ];

    protected $table = 'packages';

    public function getDirectoryAttribute(): string
    {
        if ($this->isStandard()) {
            return base_path().DIRECTORY_SEPARATOR
                .self::VENDOR_FOLDER.DIRECTORY_SEPARATOR
                .self::VENDOR_NAME.DIRECTORY_SEPARATOR;
        }

        return app_path().DIRECTORY_SEPARATOR;
    }

    public function getNamespaceAttribute(): string
    {
        return ucwords($this->name);
    }

    public function getServiceProviderAttribute(): string
    {
        return ucwords($this->name).'ServiceProvider';
    }

    public function getServiceProviderFilePathAttribute(): string
    {
        return $this->directory
            .$this->namespace.DIRECTORY_SEPARATOR
            .$this->service_provider.'.php';
    }

    public function getUrl(): string
    {
        if ($this->route && route_exists("{$this->route}.index")) {
            return url()->route("{$this->route}.index");
        }

        return '#';
    }
}
