<?php

namespace Bongo\Package\Traits;

trait HasType
{
    public function scopeStandard($query)
    {
        return $query->where('type', self::STANDARD);
    }

    public function scopeNotStandard($query)
    {
        return $query->where('type', '!=', self::STANDARD);
    }

    public function scopeExtended($query)
    {
        return $query->where('type', self::EXTENDED);
    }

    public function scopeNotExtended($query)
    {
        return $query->where('type', '!=', self::EXTENDED);
    }

    public function scopeCustom($query)
    {
        return $query->where('type', self::CUSTOM);
    }

    public function scopeNotCustom($query)
    {
        return $query->where('type', '!=', self::CUSTOM);
    }

    public function isStandard(): bool
    {
        return $this->type === self::STANDARD;
    }

    public function isExtended(): bool
    {
        return $this->type === self::EXTENDED;
    }

    public function isCustom(): bool
    {
        return $this->type === self::CUSTOM;
    }
}
