<?php

namespace Bongo\Package;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Package\Services\PackageManager;

class PackageServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'package';

    public function register(): void
    {
        parent::register();
        $this->app->singleton('package_manager', PackageManager::class);
    }

    public function boot(): void
    {
        parent::boot();

        // Once the app is booted include the helper functions
        $this->app->booted(function () {
            include __DIR__.'/helpers.php';
        });
    }
}
