<?php

namespace Bongo\Package\Services;

use Bongo\Package\Models\Package;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;

class PackageManager
{
    protected $items;

    public function __construct()
    {
        $this->items = new Collection();
        $this->items = Cache::rememberForever("packages", function () {
            return Package::orderBy('key')->get();
        });
    }

    public function has(string $key)
    {
        return $this->items->contains('key', $key);
    }

    public function get(string $key)
    {
        return $this->items->firstWhere('key', $key);
    }

    public function all()
    {
        return $this->items;
    }

    public function allActive()
    {
        return $this->items
            ->where('status', Package::ACTIVE)
            ->where('is_visible', Package::VISIBLE)
            ->all();
    }

    public function isEnabled(string $key)
    {
        return $this->items
            ->where('status', Package::ACTIVE)
            ->contains('key', $key);
    }
}
