# Changelog

All notable changes to `bongo/page` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.18] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (381 lines) - Cursor IDE guidance with project structure and patterns
  - `CLAUDE.md` (539 lines) - Claude Code quick reference with commands and architecture
  - `ARCHITECTURE.md` (1196 lines) - Detailed architecture with diagrams and data flows
  - `.github/copilot-instructions.md` (549 lines) - GitHub Copilot code templates
  - Enhanced `README.md` with 308 new lines of documentation
- **DT-518**: Individual page schema support
  - New migration `add_schema_column_to_pages_table.php` adds `schema` JSON column to pages table
  - Added schema input field in backend edit form (`src/Views/backend/edit.blade.php`)
  - Page model now supports custom schema data per page
- **DT-426**: Page export functionality
  - New `ExportPagesCommand` artisan command for data export
  - `PageExport` class using Maatwebelse Excel for export generation
  - Export view template at `src/Views/exports/pages.blade.php`
- **DT-345**: Review page stub template
  - New `thank_you_for_your_review.blade.php` stub for review confirmation pages

### Changed
- **Captcha Integration**: Updated to use new Bongo captcha package
  - Replaced old captcha implementation with `bongo/captcha` package integration
  - Added builder captcha JavaScript validation in `src/Views/frontend/builder.blade.php`
  - Simplified captcha rendering (14 insertions, 21 deletions)
- **DT-518**: Schema.org improvements
  - Updated homepage and show page views to use improved schema rendering
  - Changed schema output format in `src/Views/frontend/home.blade.php` and `show.blade.php`
- **DT-490**: Bootstrap 5.2.3 upgrade
  - Updated preview page template to use Bootstrap 5.2.3 API (28 insertions, 28 deletions)
  - Modernized JavaScript initialization in `src/Views/frontend/preview.blade.php`
- **DT-471**: Page default settings enhancement
  - Updated `DataSeeder` with 2 additional default page settings
- **DT-346**: Enhanced page stubs
  - Significantly improved Privacy Policy stub (483 insertions, 388 deletions)
  - Updated Cookie Policy stub with 4 additional lines
  - Minor refinement to Thank You page stub

## [3.0.0] - 2024-10-07

### Added (v3.0 Major Release)
- **Export System**: `ExportPagesCommand` and `PageExport` classes for data export
- **Page Relations**: New pivot table structure for page relationships
  - Migration `create_page_relation_pivot_table.php`
  - Migration `add_sort_order_column_to_page_relation_pivot_table.php`
  - Later dropped in `drop_page_relation_pivot_table.php`
- **Menu Integration**: New `menu_id` column on pages table
  - Migration `add_menu_id_column_to_pages_table.php`
  - `PageMenuComposer` for menu data injection
- **Page Stubs**: Pre-built page templates
  - `cookie_policy.blade.php` (83 lines)
  - `privacy.blade.php` (484 lines)
  - `thank_you.blade.php` (19 lines)
- **API Enhancements**:
  - New `PageResource` for API responses (22 lines)
  - Improved API controller with resource transformations

### Changed (v3.0 Major Release)
- **Service Provider Migration**: Now extends `Bongo\Framework\Providers\AbstractServiceProvider`
  - Auto-loads config, routes, views, migrations, and translations
  - Removed manual route registration in favour of `src/Routes/` convention
  - Middleware now registered via protected `$middlewares` array
- **Model Refactoring**: `Page` model refactored (97 line changes)
  - Switched to trait composition pattern
  - Updated relationships and scopes
  - Improved type hinting and return types
- **Controller Updates**:
  - `PageController` refactored (68 line changes) with improved validation
  - `PageDatatableController` enhanced (33 line changes)
  - Removed `PageImageController` (18 deletions) - functionality moved elsewhere
  - Frontend `PageController` simplified (49 line changes)
- **Migration Updates**:
  - `create_pages_table` migration refactored (91 line changes)
  - Enum columns for `transparent_header` and `sticky_header` (2 migrations)
  - Expanded `meta_description` column type
- **View Improvements**:
  - Backend edit views restructured with improved form partials
  - Frontend `builder.blade.php` refactored (90 line changes)
  - `preview.blade.php` significantly enhanced (485 insertions)
  - `show.blade.php` improvements (29 line changes)
- **Routes Refactored**:
  - `api.php`: 15 line changes
  - `backend.php`: 74 line changes
  - `frontend.php`: 46 line changes
- **Request Validation**:
  - Removed `StorePageRequest` (26 deletions) - validation moved to controller
  - `UpdatePageRequest` refactored (28 line changes)

### Fixed
- **DT-390**: Meta schema routing issues resolved (2 line changes in `frontend.php`)

### Removed
- `StorePageRequest` class - validation consolidated into controller
- `PageImageController` in backend - image handling moved to unified approach
- Page relation pivot table - replaced with direct menu relationship

## [2.0.36] - Prior Release

### Note
Version 2.x history available in git logs. Run `git log 2.0.36..3.0.0` for v2 to v3 migration details.

---

**Package**: `bongo/page`
**Description**: Web page management for Bongo CMS with builder integration
