<?php

namespace Bongo\Page\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Page\Http\Resources\PageResource;
use Bongo\Page\Models\Page;
use Illuminate\Database\Eloquent\Builder;

class PageDatatableController extends AbstractDatatableController
{
    /** @var Page */
    protected Page $page;

    public function __construct(Page $page)
    {
        $this->page = $page;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->page->newQuery();
    }

    protected function setResults()
    {
        $this->results = PageResource::collection($this->query->distinct()->get());
    }
}
