<?php

namespace Bongo\Page\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Http\Requests\StoreImageRequest;
use Bongo\Image\Services\CoverImage;
use Bongo\Page\Models\Page;
use Exception;
use Illuminate\Http\JsonResponse;

class PageImageController extends AbstractController
{
    public function upload(StoreImageRequest $request, Page $page): JsonResponse
    {
        $files = request()->file('files');

        try {
            $page = (new CoverImage($page, $files[0]))->save();

            return response()->json([$page->getPrimaryImage(['preset' => 'thumb'])]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
