<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMenuIdColumnToPagesTable extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('pages', 'menu_id')) {
            Schema::table('pages', function (Blueprint $table) {
                $table->unsignedInteger('menu_id')
                    ->nullable()
                    ->after('uuid');
            });
        }
    }

    public function down(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('menu_id');
        });
    }
}
