<?php

use Bongo\Page\Http\Controllers\Frontend\PageBackgroundImageController;
use Bongo\Page\Http\Controllers\Frontend\PageController;
use Bongo\Page\Http\Controllers\Frontend\PageImageController;
use Illuminate\Support\Facades\Route;

// Builder
Route::get('edit/{uuid}', [PageController::class, 'edit'])
    ->middleware(['auth', 'employee'])
    ->name('page.edit');

Route::post('update/{uuid}', [PageController::class, 'update'])
    ->middleware(['auth', 'employee'])
    ->name('page.update');

Route::post('image/{uuid}', [PageImageController::class, 'upload'])
    ->name('page.image');

Route::post('background/{uuid}', [PageBackgroundImageController::class, 'upload'])
    ->name('page.background_image');

// Public
Route::get('/', [PageController::class, 'index'])
    ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
    ->name('index');

Route::get('{slug}', [PageController::class, 'show'])
    ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
    ->where('slug', '.*')
    ->name('page.show');
