@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.page.update', $page) }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('page::backend.edit') }}
            @slot('actions')
                @if(user()->isDeveloper())
                    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm">
                        <css-editor-button></css-editor-button>
                    </span>
                    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm">
                        <js-editor-button></js-editor-button>
                    </span>
                    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm">
                        <schema-editor-button></schema-editor-button>
                    </span>
                @endif
                @backButton(['name' => trans('page::backend.index'), 'url' => route('backend.page.index')])
                @saveButton(['name' => trans('page::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('page::backend.partials.form.details')
        @endcomponent

    </form>
@stop
