<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'name',
                        'value' => $page->name,
                        'placeholder' => 'About Our Business',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'status',
                        'value' => $page->status,
                        'options' => get_enum_values('pages', 'status')
                    ])
                </div>
                <div class="sm:col-span-1">
                    @include('page::backend.partials.dropdowns.menu', ['model' => $page])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'label' => 'Canonical Url',
                        'name' => 'meta_canonical',
                        'value' => $page->meta_canonical,
                        'placeholder' => url()->to('/') . '/about-our-business'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Indexing',
                        'name' => 'meta_index',
                        'value' => $page->meta_index,
                        'options' => [
                            'index' => 'Index Page',
                            'noindex' => 'Dont Index Page'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Transparent Header',
                        'name' => 'transparent_header',
                        'value' => $page->transparent_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Sticky Header',
                        'name' => 'sticky_header',
                        'value' => $page->sticky_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'label' => 'Slug',
                        'name' => 'slug',
                        'value' => $page->slug,
                        'placeholder' => 'about-our-business',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'meta_title',
                        'value' => $page->meta_title,
                        'placeholder' => 'About Our Business',
                        'maxlength' => 75,
                    ])
                </div>
                <div class="sm:col-span-2">
                    @textarea([
                        'name' => 'meta_description',
                        'value' => $page->meta_description,
                        'placeholder' => 'Everything you ever wanted to know about our business',
                        'maxlength' => 150,
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    @if (!empty($page->id))
        <div class="md:col-span-1">
            @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                    <div class="sm:col-span-1">
                        @label(['name' => 'Cover / OG Image'])
                        <file-uploader
                            class="mt-2"
                            url="{{ route('backend.page.image', $page->id) }}"
                            name="cover_image"
                            height="100"
                        ></file-uploader>
                    </div>
                </div>
            @endcomponent
        </div>
    @endif
</section>

<css-editor css="{{ $page->css }}"></css-editor>
<js-editor js="{{ $page->js }}"></js-editor>
<schema-editor schema="{{ $page->schema }}"></schema-editor>
