<?php

namespace Bongo\Page\Http\Controllers\Frontend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Exceptions\BuilderException;
use Bongo\Image\Services\BuilderService;
use Bongo\Page\Events\PageUpdated;
use Bongo\Page\Models\Page;
use Illuminate\Http\Request;
use Illuminate\View\View;

class PageController extends AbstractController
{
    public function index(): View
    {
        $page = Page::where('is_home_page', 1)->first();
        if (! $page) {
            abort('404', 'Homepage could not be found');
        }

        return view('page::frontend.home', compact('page'));
    }

    public function show($slug)
    {
        // Get all the packages that are active and visible
        $page = Page::where('slug', '=', $slug)->first();
        if (! $page || (! $page->isActive() && ! auth()->user())) {
            abort('404');
        }

        if ($page->is_home_page) {
            return redirect()->to('/', 301);
        }

        return view('page::frontend.show', compact('page'));
    }

    public function edit($uuid): View
    {
        if (! $page = Page::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        return view('page::frontend.builder', compact('page'));
    }

    /**
     * @throws BuilderException
     */
    public function update(Request $request, $uuid)
    {
        if (! $page = Page::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        // Get the html
        $page->content = $request->get('html');

        // Process any images then save
        $builderService = new BuilderService($page, '/pages/');
        $page->content = $builderService->process();
        $page->save();

        event(new PageUpdated($page));

        return redirect()
            ->route('frontend.page.edit', $page->uuid)
            ->success(trans('page::backend.update_success'));
    }
}
