<?php

namespace Bongo\Page\Http\ViewComposers;

use Bongo\Menu\Models\Menu;
use Illuminate\View\View;

class PageMenuComposer
{
    public function compose(View $view): void
    {
        $menus = Menu::active()
            ->orderBy('name', 'ASC')
            ->pluck('name', 'id')
            ->toArray();

        if (! $menus) {
            $menus = [];
        }

        $view->with(compact('menus'));
    }
}
