<?php

use Bongo\Page\Models\Page;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTransparentHeaderColumnToPagesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('pages', 'transparent_header')) {
            Schema::table('pages', function (Blueprint $table) {
                $table->tinyInteger('transparent_header')
                    ->default(Page::ENABLED)
                    ->after('status');
            });
        }
    }

    public function down()
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('transparent_header');
        });
    }
}
