<?php

use Bongo\Page\Models\Page;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStickyHeaderColumnToPagesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('pages', 'sticky_header')) {
            Schema::table('pages', function (Blueprint $table) {
                $table->tinyInteger('sticky_header')
                    ->default(Page::ENABLED)
                    ->after('transparent_header');
            });
        }
    }

    public function down()
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('sticky_header');
        });
    }
}
