<?php

namespace Bongo\Page\Seeders;

use Bongo\Page\Models\Page;
use Bongo\Page\PageServiceProvider;
use Illuminate\Database\Seeder;

class DataSeeder extends Seeder
{
    public function run()
    {
        $rows = [
            [
                'name' => 'Home',
                'slug' => 'home',
                'status' => Page::ACTIVE,
                'is_home_page' => 1,
            ],
            [
                'name' => 'About',
                'slug' => 'about-us',
                'status' => Page::ACTIVE,
            ],
            [
                'name' => 'Thank You',
                'slug' => 'thank-you',
                'status' => Page::ACTIVE,
                'meta_index' => Page::NO_INDEX,
            ],
            [
                'name' => 'Thank You For Your Review',
                'slug' => 'thank-you-for-your-review',
                'status' => Page::ACTIVE,
                'meta_index' => Page::NO_INDEX,
            ],
            [
                'name' => 'Privacy',
                'slug' => 'privacy',
                'status' => Page::ACTIVE,
            ],
            [
                'name' => 'Cookie Policy',
                'slug' => 'cookie-policy',
                'status' => Page::ACTIVE,
            ],
            [
                'name' => 'Terms',
                'slug' => 'terms',
                'status' => Page::ACTIVE,
            ],
        ];

        foreach ($rows as $row) {
            $this->command->info('Creating page: '.$row['name']);

            // Create the page
            $page = Page::firstOrCreate($row);

            // Check if we have a stub for the content of this page
            $stubFile = PageServiceProvider::getDir().'/Views/stubs/'.$page->key.'.blade.php';

            // If we have a stub, add the content to the page
            if (file_exists($stubFile)) {
                $page->content = file_get_contents($stubFile);
                $this->command->info('Stub found, adding content to page: '.$page->key);
                $page->save();
            }
        }
    }
}
