@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('page::backend.index') }}
        @slot('actions')
            @backButton(['name' => trans('dashboard::backend.index')])
            @include('page::backend.partials.btn_create')
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.page.datatable') }}"
            resource-url="{{ route('backend.page.index') }}"
            builder="/edit"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                            :value="getFilterValue('status')"
                            @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>

            <template
                slot="default"
                slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl, editUrl, duplicateUrl, builderUrl}"
            >
                <div class="grid md:grid-cols-2 gap-3">

                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <template slot="left">
                            <a :href="viewUrl(item)" title="View"
                               class="block font-semibold hover:text-primary-500 focus:text-primary-600 flex items-center"
                            >
                                @{{ item.name }}
                                <span v-if="item.is_home_page" class="ml-1 text-primary-500">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"
                                         xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"
                                        ></path>
                                    </svg>
                                </span>
                            </a>
                            <div v-if="item.status"
                                 :class="['text-sm', item.status === 'active' ? 'text-green-400' : 'text-red-500']"
                            >
                                @{{ item.status | ucwords }}
                            </div>
                            <div v-if="item.slug" class="text-sm text-gray-400">
                                @{{ item.slug }}
                            </div>
                        </template>

                        <template slot="right">
                            <v-button :link="viewUrl(item)">View</v-button>
                            <v-button :link="editUrl(item)">Edit</v-button>
                            <v-button :link="builderUrl(item)" :target="'_blank'">Builder</v-button>
                        </template>
                    </v-card>

                </div>
            </template>
        </data-table>
    @endcomponent
@stop
