@extends('framework::frontend.layouts.app')

@section('meta_title', $page->meta_title)
@section('meta_description', $page->meta_description)
@section('meta_index', $page->meta_index)
@section('meta_canonical', $page->meta_canonical)
@section('meta_image', asset($page->getPrimaryImage(['preset' => 'large'])))
@section('meta_schema'){!! SEO::getMetaSchemaForPage($page) !!}@endsection

@section('header_class', $page->getHeaderClass())
@section('page_css', $page->css)
@section('page_javascript')
    {!! $page->js !!}
@endsection

@section('admin_menu_actions')
    <li class="nav-item">
        <a href="{{ route('frontend.page.edit', $page->uuid) }}">
            <i class="fas fa-external-link-alt" style="top: 0;"></i>
            Page Builder
        </a>
    </li>
@endsection

@section('content')
    @if($page->hasMenu())
        <div id="silo-menu">
            <div class="container">
                <ul>
                    @foreach($page->menu->items as $menuItem)
                        <li>
                            <a class="silo-menu-item item-{{ Str::slug($menuItem->name) }} {{ $menuItem->isActive() ? 'active' : '' }}"
                               href="{{ $menuItem->getLink() }}"
                               title="Link to {{ $menuItem->name }}"
                               aria-label="Link to {{ $menuItem->name }}"
                               target="{{ $menuItem->target }}"
                            >
                                {{ $menuItem->name }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    @endif

    <div class="is-wrapper">
        {!! $page->content_clean !!}
    </div>
@stop


