<?php

namespace Bongo\Page\Commands;

use Bongo\Page\Exports\PageExport;
use Bongo\Page\Models\Page;
use Illuminate\Console\Command;
use Maatwebsite\Excel\Facades\Excel;

class ExportPagesCommand extends Command
{
    /** @var string */
    protected $signature = 'page:export';

    /** @var string */
    protected $description = 'Exports the pages to a csv file.';

    public function handle(): void
    {
        console_print('Exporting pages to a csv file...');

        $rows = Page::all();

        Excel::store(new PageExport($rows), 'pages.csv');

        console_print('Pages exported to '. storage_path('pages.csv'));
    }
}
