<?php

namespace Bongo\Page\Http\Controllers\Frontend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Services\WysiwygImage;
use Bongo\Page\Models\Page;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PageBackgroundImageController extends AbstractController
{
    public function upload(Request $request, $uuid): string
    {
        // Find the page or fail
        if (! $page = Page::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        // Validate that this is an image or fail
        $validator = Validator::make($request->all(), ['fileCover' => 'image|max:4096']);
        if ($validator->fails()) {
            $errorMessage = $validator->errors()->first();

            return "<html><body onload=\"alert('${errorMessage}')\"></body></html>";
        }

        // Get the file and try the upload
        $file = $request->file('fileCover');

        try {
            $image = (new WysiwygImage($page, $file))->save();

            // Return the link to the file
            $fileLink = '/'.config('image.prefix')."/{$image->name}";

            return "<html><body onload=\"parent.applyBoxImage('".$fileLink."');\"></body></html>";

        } catch (Exception $e) {
            return "<html><body onload=\"alert('Sorry, your file was not uploaded.')\"></body></html>";
        }
    }
}
