<?php

namespace Bongo\Page\Http\Requests;

use Bongo\Page\Models\Page;
use Illuminate\Foundation\Http\FormRequest;

class StorePageRequest extends FormRequest
{
    public function rules(): array
    {
        $pageTable = (new Page())->getTable();

        return [
            'name' => 'required',
            'slug' => "required|max:75|unique:{$pageTable},slug,NULL,id,deleted_at,NULL",
        ];
    }
}
