<?php

use Bongo\Page\Models\Page;
use Bongo\Page\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

class CreatePagesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('pages')) {
            Schema::create('pages', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Fields
                $table->string('name');
                $table->string('key')->nullable()->index();
                $table->string('slug')->index();
                $table->longText('content')->nullable();
                $table->enum('status', [Page::PENDING, Page::ACTIVE, Page::INACTIVE])->default(Page::PENDING);
                $table->unsignedTinyInteger('is_home_page')->default(0)->index();

                // Overrides
                $table->mediumText('css')->nullable();
                $table->mediumText('js')->nullable();

                // SEO Fields
                $table->string('meta_title')->nullable();
                $table->text('meta_description')->nullable();
                $table->enum('meta_index', [Page::INDEX, Page::NO_INDEX])->default(Page::INDEX);
                $table->string('meta_canonical')->nullable();

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->unsignedInteger('deleted_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
