<?php

use Bongo\Page\Models\Page;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageRelationPivotTable extends Migration
{
    public function up()
    {
        Schema::create('page_relation_pivot', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('page_id')
                ->unsigned()
                ->nullable();

            $table->foreign('page_id')
                ->references('id')
                ->on('pages')
                ->onDelete('cascade');

            $table->integer('relation_id')
                ->unsigned()
                ->nullable();

            $table->foreign('relation_id')
                ->references('id')
                ->on('pages')
                ->onDelete('cascade');

            $table->enum('relation_type', [Page::PARENT, Page::CHILD, Page::SIBLING])
                ->default(Page::SIBLING);
        });
    }

    public function down()
    {
        Schema::dropIfExists('page_relation_pivot');
    }
}
