<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSortOrderColumnToPageRelationPivotTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('page_relation_pivot', 'sort_order')) {
            Schema::table('page_relation_pivot', function (Blueprint $table) {
                $table->integer('sort_order')
                    ->nullable()
                    ->after('relation_type');
            });
        }
    }

    public function down()
    {
        Schema::table('page_relation_pivot', function (Blueprint $table) {
            $table->dropColumn('sort_order');
        });
    }
}
