<?php

use Bongo\Page\Http\Controllers\Backend\PageController;
use Bongo\Page\Http\Controllers\Backend\PageDatatableController;
use Bongo\Page\Http\Controllers\Backend\PageImageController;
use Illuminate\Support\Facades\Route;

Route::as('page.')
    ->prefix(config('page.prefix'))
    ->group(function () {

        Route::get('/', [PageController::class, 'index'])
            ->name('index');

        Route::get('create', [PageController::class, 'create'])
            ->name('create');

        Route::post('store', [PageController::class, 'store'])
            ->name('store');

        Route::get('datatable', [PageDatatableController::class, 'index'])
            ->name('datatable');

        // Page/{page}/
        Route::prefix('{page}')
            ->group(function () {

                Route::get('/', [PageController::class, 'show'])
                    ->name('show');

                Route::get('edit', [PageController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [PageController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [PageController::class, 'destroy'])
                    ->name('destroy');

                Route::get('duplicate', [PageController::class, 'duplicate'])
                    ->name('duplicate');

                Route::post('image', [PageImageController::class, 'upload'])
                    ->name('image');
            });
    });
