@if ($numberOfPages >= setting('package::page.number_of_pages'))
    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm">
        <a href="mailto:{{ config('developer.email') }}?subject={{ trans('page::backend.page_limit_reached') }}"
           class="inline-flex items-center px-4 py-2 border border-transparent text-sm leading-5 font-medium rounded-sm text-white bg-yellow-400 hover:bg-yellow-500 focus:outline-none focus:shadow-outline-yellow focus:border-yellow-600 active:bg-yellow-600 transition duration-150 ease-in-out"
           title="{{ trans('page::backend.page_limit_reached') }}, {{ trans('page::backend.contact_support', ['email' => config('developer.email')]) }}"
           aria-label="{{ trans('page::backend.page_limit_reached') }}, {{ trans('page::backend.contact_support', ['email' => config('developer.email')]) }}"
           v-tooltip='"<b>{{ trans('page::backend.page_limit_reached') }}</b>, {{ trans('page::backend.contact_support', ['email' => config('developer.email')]) }}"'
        >
            <svg class="-ml-1 mr-2 h-5 w-5 text-yellow-200" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd"
                      d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"
                      clip-rule="evenodd"
                />
            </svg>
            {{ trans('page::backend.page_limit_reached') }}
        </a>
    </span>
@else
    @createButton(['name' => trans('page::backend.create'), 'url' => route('backend.page.create')])
@endif
