<table>
    <thead>
        <tr>
            <th>id</th>
            <th>name</th>
            <th>slug</th>
            <th>content</th>
            <th>status</th>
            <th>meta_title</th>
            <th>meta_description</th>
        </tr>
    </thead>
    <tbody>
        @foreach($rows as $row)
            <tr>
                <td>
                    {{ $row->id ?? '' }}
                </td>
                <td>
                    @if(! empty($row->name))
                        {{ html_entity_decode(strip_tags(str_replace('</p>', "\n", $row->name))) }}
                    @endif
                </td>
                <td>
                    {{ $row->slug ?? '' }}
                </td>
                <td>
                    @if(! empty($row->content))
                        {{ $row->getContentAsPlainText('<img><br><p><strong><span>') }}
                    @endif
                </td>
                <td>
                    {{ $row->status ?? '' }}
                </td>
                <td>
                    @if(! empty($row->meta_title))
                        {{ html_entity_decode(strip_tags(str_replace('</p>', "\n", $row->meta_title))) }}
                    @endif
                </td>
                <td>
                    @if(! empty($row->meta_description))
                        {{ html_entity_decode(strip_tags(str_replace('</p>', "\n", $row->meta_description))) }}
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
