@extends('framework::frontend.layouts.app')

@section('meta_title', $page->meta_title)
@section('meta_description', $page->meta_description)
@section('meta_index', $page->meta_index)
@section('meta_canonical', $page->meta_canonical)
@section('meta_image', asset($page->getPrimaryImage(['preset' => 'large'])))
@section('meta_schema'){!! SEO::getMetaSchemaForPage($page) !!}@endsection

@section('header_class', $page->getHeaderClass())
@section('body_class', 'home-page')
@section('page_css', $page->css)
@section('page_javascript')
    {!! $page->js !!}
@endsection
@section('heading', false)

@section('admin_menu_actions')
    <li class="nav-item">
        <a href="{{ route('frontend.page.edit', $page->uuid) }}">
            <i class="fas fa-external-link-alt" style="top: 0;"></i>
            Page Builder
        </a>
    </li>
@endsection

@section('content')
    <div class="is-wrapper">
        {!! $page->content_clean !!}
    </div>
@stop
