<?php

namespace Bongo\Page;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Menu\Listeners\ClearMenuCache;
use Bongo\Page\Commands\ExportPagesCommand;
use Bongo\Page\Events\PageCreated;
use Bongo\Page\Events\PageDeleted;
use Bongo\Page\Events\PageUpdated;
use Bongo\Page\Http\ViewComposers\CreatePageComposer;
use Bongo\Page\Http\ViewComposers\PageMenuComposer;
use Bongo\Sitemap\Listeners\UpdateSitemap;

class PageServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'page';

    protected array $commands = [
        ExportPagesCommand::class,
    ];

    protected array $composers = [
        PageMenuComposer::class => [
            'page::backend.partials.dropdowns.menu',
        ],
        CreatePageComposer::class => [
            'page::backend.partials.btn_create',
        ],
    ];

    protected array $listeners = [
        PageCreated::class => [],
        PageUpdated::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        PageDeleted::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
    ];
}
