@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $page->name }}
        @slot('actions')
            @linkButton(['name' => 'Page Builder','url' => route('frontend.page.edit', $page->uuid),'target' => '_blank'])
            @linkButton(['name' => trans('page::backend.show'),'url' => route('frontend.page.show', $page->slug),'target' => '_blank'])
            @linkButton(['name' => trans('page::backend.duplicate'),'url' => route('backend.page.duplicate', $page->id)])
            @deleteButton(['name' => trans('page::backend.delete'), 'url' => route('backend.page.destroy', $page->id)])
            @backButton(['name' => trans('page::backend.index'), 'url' => route('backend.page.index')])
            @editButton(['name' => trans('page::backend.edit'), 'url' => route('backend.page.edit', $page->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Name', 'value' => $page->name])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($page->status) ? ucwords($page->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Menu', 'value' => $page->hasMenu() ? $page->menu->name : '-- --'])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Canonical Url', 'value' => $page->meta_canonical])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Indexing',
                                'value' => ! empty($page->meta_index) ? ucwords($page->meta_index) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Transparent Header',
                                'value' => ! empty($page->transparent_header) ? ucwords($page->transparent_header) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Sticky Header',
                                'value' => ! empty($page->sticky_header) ? ucwords($page->sticky_header) : null
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2 lg:grid-cols">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Slug', 'value' => $page->slug])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Title', 'value' => $page->meta_title])
                        </div>
                        <div class="sm:col-span-2">
                            @static(['name' => 'Meta Description', 'value' => $page->meta_description])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-2">
                @if($page->isActive())
                    <preview url="{{ route('frontend.page.show', $page->slug) }}"></preview>
                @endif
            </div>
        </section>
    @endcomponent
@stop
