<?php

namespace Bongo\Post\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PostResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'key' => $this->key,
            'slug' => $this->slug,
            'thumbnail' => $this->hasImages() ? $this->getPrimaryImage(['preset' => 'thumb']) : '/images/default_image.png',
            'name' => $this->name,
            'summary' => $this->summary,
            'content' => $this->content,
            'date' => $this->date,
            'status' => $this->status,
        ];
    }
}
