<?php

namespace Bongo\Post\Http\ViewComposers;

use Bongo\Post\Models\Post;
use Illuminate\View\View;

class RecentPostsComposer
{
    public function compose(View $view): void
    {
        // Get the posts
        $posts = Post::active()->limit(2)->latest()->get();
        if (! $posts) {
            $posts = [];
        }

        // Pass the data to the view partial
        $view->with(compact('posts'));
    }
}
