<?php

use Bongo\Post\Models\PostCategory;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTransparentHeaderColumnToPostCategoriesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('post_categories', 'transparent_header')) {
            Schema::table('post_categories', function (Blueprint $table) {
                $table->tinyInteger('transparent_header')
                    ->default(PostCategory::ENABLED)
                    ->after('status');
            });
        }
    }

    public function down()
    {
        Schema::table('post_categories', function (Blueprint $table) {
            $table->dropColumn('transparent_header');
        });
    }
}
