<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSummaryColumnToPostsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('posts', 'summary')) {
            Schema::table('posts', function (Blueprint $table) {
                $table->mediumText('summary')->nullable()->after('content');
            });
        }
    }

    public function down()
    {
        Schema::table('posts', function (Blueprint $table) {
            $table->dropColumn('summary');
        });
    }
}
