<?php

namespace Bongo\Post\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasContent;
use Bongo\Framework\Traits\HasHeaderClass;
use Bongo\Framework\Traits\HasKey;
use Bongo\Framework\Traits\HasSeo;
use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Bongo\Image\Interfaces\Imageable;
use Bongo\Image\Traits\HasImages;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostCategory extends AbstractModel implements Imageable
{
    // status
    public const PENDING = 'pending';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';

    public const INDEX = 'index';
    public const NO_INDEX = 'noindex';

    // booleans
    public const ENABLED = 1;
    public const DISABLED = 0;

    use HasContent;
    use HasHeaderClass;
    use HasImages;
    use HasKey;
    use HasSeo;
    use HasStatus;
    use HasUUID;
    use SoftDeletes;

    /** @var array */
    protected $fillable = [
        'name',
        'slug',
        'content',
        'status',
        'meta_title',
        'meta_description',
        'meta_canonical',
        'meta_index',
        'css',
        'js',
    ];

    public function posts(): BelongsToMany
    {
        return $this->belongsToMany(Post::class, 'post_categories_pivot');
    }
}
