<?php

namespace Bongo\Post;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Menu\Listeners\ClearMenuCache;
use Bongo\Post\Events\PostCategoryDeleted;
use Bongo\Post\Events\PostCategoryUpdated;
use Bongo\Post\Events\PostCreated;
use Bongo\Post\Events\PostDeleted;
use Bongo\Post\Events\PostUpdated;
use Bongo\Post\Http\ViewComposers\PostCategoryComposer;
use Bongo\Post\Http\ViewComposers\PostComposer;
use Bongo\Post\Listeners\SetPostDate;
use Bongo\Post\Listeners\SetPostUser;
use Bongo\Post\Models\PostCategory;
use Bongo\Sitemap\Listeners\UpdateSitemap;
use Illuminate\Foundation\AliasLoader;

class PostServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'post';

    protected array $composers = [
        PostComposer::class => [
            'post::backend.partials.dropdowns.post',
        ],
        PostCategoryComposer::class => [
            'post::backend.category.partials.dropdowns.category',
        ],
    ];

    protected array $listeners = [
        PostCreated::class => [
            SetPostDate::class,
            SetPostUser::class,
        ],
        PostUpdated::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        PostDeleted::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        PostCategoryUpdated::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        PostCategoryDeleted::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
    ];

    public function boot(): void
    {
        parent::boot();
        AliasLoader::getInstance()->alias('PostCategory', PostCategory::class);
    }
}
