@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $post->name }}
        @slot('actions')
            @linkButton(['name' => 'Post Builder','url' => route('frontend.post.edit', $post->uuid),'target' => '_blank'])
            @linkButton(['name' => trans('post::backend.show'),'url' => route('frontend.post.show', $post->slug),'target' => '_blank'])
            @linkButton(['name' => trans('post::backend.duplicate'),'url' => route('backend.post.duplicate', $post->id)])
            @deleteButton(['name' => trans('post::backend.delete'), 'url' => route('backend.post.destroy', $post->id)])
            @backButton(['name' => trans('post::backend.index'), 'url' => route('backend.post.index')])
            @editButton(['name' => trans('post::backend.edit'), 'url' => route('backend.post.edit', $post->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Name', 'value' => $post->name])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($post->status) ? ucwords($post->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Canonical Url', 'value' => $post->meta_canonical])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Indexing',
                                'value' => ! empty($post->meta_index) ? ucwords($post->meta_index) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Transparent Header',
                                'value' => ! empty($post->transparent_header) ? ucwords($post->transparent_header) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Sticky Header',
                                'value' => ! empty($post->sticky_header) ? ucwords($post->sticky_header) : null
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2 lg:grid-cols">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Slug', 'value' => $post->slug])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Title', 'value' => $post->meta_title])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Description', 'value' => $post->meta_description])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @label(['name' => 'Categories'])
                            <div class="mt-1 text-sm leading-5 text-gray-900 {{ $class ?? '' }}">
                                @if (isset($post->categories) && count($post->categories))
                                    @foreach ($post->categories as $postCategory)
                                        <span
                                            class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-gray-100 text-gray-800"
                                        >
                                            {{ $postCategory->name }}
                                        </span>
                                    @endforeach
                                @else
                                    -- --
                                @endif
                            </div>
                        </div>
                        <div class="sm:col-span-1">
                            @label(['name' => 'Cover / OG Image'])
                            <img
                                class="img-fluid mx-auto d-block w-100"
                                src="{{ $post->getPrimaryImage(['preset' => 'large']) }}"
                                alt="{{ $post->name }}"
                            />
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Summary', 'value' => $post->summary, 'isHtml' => true])
                @endcomponent
            </div>

            <div class="md:col-span-2">
                @if($post->isActive())
                    <preview url="{{ route('frontend.post.show', $post->slug) }}"></preview>
                @endif
            </div>
        </section>
    @endcomponent

@stop
