<?php

namespace Bongo\Post\Listeners;

use Carbon\Carbon;
use Illuminate\Contracts\Queue\ShouldQueue;

class SetPostDate implements ShouldQueue
{
    public int $tries = 3;

    public function handle($event): void
    {
        if (empty($event->post->date)) {
            $event->post->date = Carbon::now()->format('Y-m-d H:i:s');
            $event->post->save();
        }
    }
}
