<?php

use Bongo\Post\Models\Post;
use Bongo\Post\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class CreatePostsTable extends Migration
{
    public function up()
    {
        Schema::create(Str::plural('post'), function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // foreign keys
            $table->unsignedInteger('user_id')->nullable()->index();

            // Fields
            $table->timestamp('date')->nullable();
            $table->string('name');
            $table->string('key')->nullable()->index();
            $table->string('slug')->index();
            $table->longText('content')->nullable();
            $table->enum('status', [Post::PENDING, Post::ACTIVE, Post::INACTIVE])->default(Post::PENDING);

            // Overrides
            $table->text('css')->nullable();
            $table->text('js')->nullable();

            // SEO Fields
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->enum('meta_index', [Post::INDEX, Post::NO_INDEX])->default(Post::INDEX);
            $table->string('meta_canonical')->nullable();

            // Audit
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->unsignedInteger('deleted_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class]);
        }
    }

    public function down()
    {
        Schema::dropIfExists(Str::plural('post'));
    }
}
