<?php

use Bongo\Post\Models\PostCategory;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostCategoriesTable extends Migration
{
    public function up()
    {
        Schema::create('post_categories', function (Blueprint $table) {
            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Fields
            $table->string('name');
            $table->string('key')->nullable()->index();
            $table->string('slug')->index();
            $table->text('content')->nullable();
            $table->enum('status',
                [PostCategory::PENDING, PostCategory::ACTIVE, PostCategory::INACTIVE])->default(PostCategory::PENDING);

            // Overrides
            $table->text('css')->nullable();
            $table->text('js')->nullable();

            // SEO Fields
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->enum('meta_index', [PostCategory::INDEX, PostCategory::NO_INDEX])->default(PostCategory::INDEX);
            $table->string('meta_canonical')->nullable();

            // Audit
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->unsignedInteger('deleted_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('post_categories');
    }
}
